<?php

$this->pageTitle = Yii::app()->name.' - Przenieś ucznia';

$this->breadcrumbs = array(
	'Uczniowie'=>array('admin'),
	'Przenieś ucznia '.$model->imie.' '.$model->nazwisko,
);

?>
<h1>Przenieś ucznia <?php echo $model->imie.' '.$model->nazwisko; ?> do innej firmy</h1>
<form id="userChangeCompany" action="<?php echo $this->createUrl('/administration/uzytkownik/changeCompany', array('id'=>$model->id)) ?>" method="post">
<?php foreach ($firmy as $indx=>$firma): ?>
<p>
	<label for="companyId_<?php echo $firma->id ?>" style="font-weight: bold; display: block; background-color: #a4ca6c">
		<input type="radio" name="companyId" value="<?php echo $firma->id; ?>" id="companyId_<?php echo $firma->id ?>" <?php echo $firma->id == $model->idFirmy ? 'checked' : '' ?>><b><?php echo $firma->nazwa != ' ' ? $firma->nazwa : 'Nienazwana firma'; ?></b>
	</label>
	<?php
		$this->widget('zii.widgets.grid.CGridView', array(
			'id' => 'uczniowie-firma-' . $firma->id,
			'dataProvider'=>new CArrayDataProvider($firma->activeUsers, array(
				'pagination' => false
			)),
			'summaryText' => false,
			'htmlOptions' => array('class' => 'tDefault eqSize'),
			'columns'=>array(
				'imie',
				'nazwisko',
			),
		));
	?>
</p>
<?php endforeach; ?>
<input class="buttonS bLightBlue" type="submit" name="yt0" value="Zapisz">

</form>
